CREATE PROCEDURE CP_Cbtes_Grabar_Numero @Id_Trans INT
AS

DECLARE @Mensaje				VARCHAR(100)
		,@Id_Tipo_Cbte			CHAR(4)
		,@Fecha_Cai				DATETIME
		,@Nro_Cai				VARCHAR(14)
		,@Flag_Val_Correla		TINYINT
		,@Compromete_Factura	SMALLINT
		,@Fecha					DATETIME
		,@Fecha_Cbte			DATETIME
		,@Comprobante_Nro		INT
		,@Id_Estado_Cbte		SMALLINT
		,@Id_Cond_Pago			SMALLINT
		,@Compromete_Recibos	SMALLINT
		,@Compromete_Pagos		SMALLINT
						
BEGIN TRY
	BEGIN TRAN

	IF (NOT EXISTS (SELECT 1 FROM Cbtes WHERE Id_Trans = @Id_Trans))
	BEGIN
		SELECT	 1					AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,'No Existe Cbte de Origen'			AS ErrorMessage
				,@Id_Trans      	AS Id_Trans
		ROLLBACK
		RETURN 1
    END

	SELECT @Id_Tipo_Cbte = ISNULL(T.Id_Tipo_Cbte,'')
			, @Fecha_Cai = T.Fecha_Cai
			, @Nro_Cai = T.Nro_Cai
			, @Flag_Val_Correla = ISNULL(T.Flag_Val_Correla,0)
			, @Compromete_Factura = ISNULL(T.Compromete_Factura,0)
			, @Id_Estado_Cbte = ISNULL(T.Id_Estado_Cbte,0)
			, @Id_Cond_Pago = ISNULL(C.Id_Cond_Pago,0)
			, @Compromete_Recibos = ISNULL(Compromete_Recibos,0)
			, @Compromete_Pagos	= ISNULL(Compromete_Pagos,0)
			, @Fecha_Cbte = C.Fecha
			, @Comprobante_Nro = ISNULL(T.Prox_Nro,1)
			FROM Cbtes_Tipos T, Cbtes C
			WHERE T.Id_Tipo_Cbte = dbo.CF_Cbte_Traer_Tipo_Dest(C.Id_Tipo_Cbte)
			AND C.Id_Trans = @Id_Trans

    IF @Flag_Val_Correla = 1 OR (@Compromete_Factura <> 0 AND CAST( dbo.CF_xParam('Fact_Cont_FN') AS INT ) <> 0 )
	BEGIN
	   SELECT @Fecha = MAX(Fecha),@Comprobante_Nro = ISNULL(MAX(Comprobante_Nro),0) + 1 FROM Cbtes 
            WHERE (Id_Tipo_Cbte = @Id_Tipo_Cbte 
					OR Id_Tipo_Cbte  IN (SELECT Id_Tipo_Cbte FROM Cbtes_Tipos 
					WHERE Id_Tipo_Cbte_Dest = @Id_Tipo_Cbte)) --para destino y todos los cbtes que dependen del destino
				AND NOT (Id_Estado_Cbte = 3 AND Comprobante_Nro = 0)

	   SET @Fecha = ISNULL(@Fecha,GETDATE())
	   SET @Comprobante_Nro = ISNULL(@Comprobante_Nro,1)
	   IF @Fecha > @Fecha_Cbte
			SET @Fecha_Cbte = @Fecha
	END

	IF @Id_Estado_Cbte = 0  --si no tenia valor por defecto
	BEGIN
		SET @Id_Estado_Cbte = 1  --Pendiente
		IF (@Compromete_Factura <> 0 AND @Id_Cond_Pago = 1 ) OR @Compromete_Recibos <> 0 OR @Compromete_Pagos <> 0
			SET @Id_Estado_Cbte = 2	 --Completo
	END


	UPDATE Cbtes SET Comprobante_Nro = @Comprobante_Nro 
						,Fecha = @Fecha_Cbte
						,Id_Estado_Cbte = @Id_Estado_Cbte
						,Cai_Vence  = @Fecha_Cai
						,Cai = @Nro_Cai
						,Nro_Auto_Trib = @Nro_Cai
						 WHERE Id_Trans = @Id_Trans
	UPDATE Cbtes_Tipos SET Fecha_Ult = @Fecha_Cbte, Prox_Nro = @Comprobante_Nro + 1
			WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte 
					OR Id_Tipo_Cbte  IN (SELECT Id_Tipo_Cbte FROM Cbtes_Tipos 
					WHERE Id_Tipo_Cbte_Dest = @Id_Tipo_Cbte) --para destino y todos los cbtes que dependen del destino

	COMMIT
	SELECT	 0					AS ErrorNumber 
			,0					AS ErrorSeverity  
			,0					AS ErrorState 
			,0					AS ErrorProcedure  
			,0					AS ErrorLine		
			,@Mensaje			AS ErrorMessage
			,@Id_Trans      	AS Id_Trans
			,@Id_Tipo_Cbte		AS Id_Tipo_Cbte
			,@Id_Estado_Cbte    AS Id_Estado_Cbte
			,@Comprobante_Nro	AS Comprobante_Nro


END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;   

